<?php

/*
 * This file is part of the Claroline Connect package.
 *
 * (c) Claroline Consortium <consortium@claroline.net>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Claroline\CoreBundle\DataFixtures\Optional;

use Symfony\Component\DependencyInjection\ContainerAwareInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Claroline\CoreBundle\Library\Fixtures\LoggableFixture;

class LoadWorkspaceTagData extends LoggableFixture implements ContainerAwareInterface
{
    private $container;
    private $tags;

    public function __construct(array $tags)
    {
        $this->tags = $tags;
    }

    public function setContainer(ContainerInterface $container = null)
    {
        $this->container = $container;
    }

    public function load(ObjectManager $manager)
    {
        foreach ($this->tags as $data) {
            $user = null;

            if (isset($data['user'])) {
                $user = $this->getReference('user/' . $data['user']);
            }

            $tag = $this->container->get('claroline.manager.workspace_tag_manager')->createTag(
                $data['name'],
                $user
            );

            $this->addReference('tag/' . $data['name'], $tag);
        }
        $manager->flush();
    }
}
