/*
 * Decompiled with CFR 0.152.
 */
package com.moxiecode.ant.tasks;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class PreProcessTask
extends Task {
    protected String inFile;
    protected String outFile;
    protected String[] defines = new String[]{""};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preProcess(InputStream in_stream, OutputStream out_stream, String[] defines) throws IOException {
        BufferedReader in = null;
        BufferedWriter out = null;
        int currentLevel = 0;
        int removeLevel = -1;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(in_stream));
            out = new BufferedWriter(new OutputStreamWriter(out_stream));
            Pattern pattern = Pattern.compile("^\\s*[<!--|\\/\\/|\\/\\*]*\\s*#(ifdef|ifndef|endif)\\s*(\\w*)\\s*[-->|\\/\\/|\\*\\/]*$");
            while ((line = in.readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                if (matcher.matches()) {
                    int i;
                    boolean found;
                    String define;
                    MatchResult res = matcher.toMatchResult();
                    if (res.group(1).equals("ifdef")) {
                        define = res.group(2);
                        found = false;
                        for (i = 0; i < defines.length; ++i) {
                            if (!define.equals(defines[i])) continue;
                            found = true;
                            break;
                        }
                        if (removeLevel == -1 && !found) {
                            removeLevel = currentLevel;
                        }
                        ++currentLevel;
                        continue;
                    }
                    if (res.group(1).equals("ifndef")) {
                        define = res.group(2);
                        found = false;
                        for (i = 0; i < defines.length; ++i) {
                            if (!define.equals(defines[i])) continue;
                            found = true;
                            break;
                        }
                        if (removeLevel == -1 && found) {
                            removeLevel = currentLevel;
                        }
                        ++currentLevel;
                        continue;
                    }
                    if (res.group(1).equals("endif")) {
                        if (--currentLevel != removeLevel) continue;
                        removeLevel = -1;
                        continue;
                    }
                }
                if (removeLevel != -1 && currentLevel >= removeLevel) continue;
                out.write(line);
                out.newLine();
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    public void execute() throws BuildException {
        try {
            if (this.inFile == null || this.outFile == null) {
                throw new BuildException("Missing required: infile or outfile parameters.");
            }
            this.preProcess(new FileInputStream(this.inFile), new FileOutputStream(this.outFile), this.defines);
        }
        catch (IOException ex) {
            throw new BuildException("I/O Error when preprocessing file", (Throwable)ex);
        }
    }

    public void setInFile(String in_file) {
        this.inFile = in_file;
    }

    public void setOutFile(String out_file) {
        this.outFile = out_file;
    }

    public void setDefines(String defines) {
        this.defines = defines.replaceAll("\\s+", "").split(",");
    }
}

